/*
 * Decompiled with CFR 0.152.
 */
package com.mmkrasel.utils;

import com.mmkrasel.utils.BanglaWordConverter;
import com.mmkrasel.utils.CustomDrawString;
import com.mmkrasel.utils.Default;
import com.mmkrasel.utils.StringUtility;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CustomLanguage {
    private String[] words;
    private int[][][] textBits;
    private int[] wordsLength;
    private int strLen;
    private int fontH;
    private int maxRightX;
    private int height;
    private int endX;
    private int minX;
    private int topY;
    private int startX;
    private boolean singleLine;
    private boolean underLine;
    private boolean dotsExist;
    private String locale;
    int numOfWords = 0;

    public CustomLanguage(int n, int n2, int n3, int n4) {
        this.minX = n;
        this.maxRightX = n2;
        this.startX = n3;
        this.topY = n4;
        this.locale = "en_us";
        this.strLen = 0;
        this.fontH = 20;
        this.singleLine = false;
        this.underLine = false;
        this.dotsExist = false;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public void setLeftX(int n) {
        this.startX = n;
    }

    public void setMinX(int n) {
        this.minX = n;
    }

    public void setTopY(int n) {
        this.topY = n;
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
    }

    public void setUnderLine(boolean bl) {
        this.underLine = bl;
    }

    private Vector stringTokenized(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        try {
            int n;
            StringUtility stringUtility = new StringUtility(string);
            string = null;
            String[] stringArray = stringUtility.split(string2);
            String[][] stringArrayArray = new String[stringArray.length][];
            for (n = 0; n < stringArray.length; ++n) {
                stringUtility = null;
                try {
                    stringUtility = new StringUtility(stringArray[n]);
                    stringArrayArray[n] = stringUtility.split(string3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringArray = null;
            for (n = 0; n < stringArrayArray.length; ++n) {
                try {
                    for (int i = 0; i < stringArrayArray[n].length; ++i) {
                        if (stringArrayArray[n][i] == null || stringArrayArray[n][i].length() <= 0) continue;
                        vector.addElement(stringArrayArray[n][i]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n < stringArrayArray.length - 1) {
                    vector.addElement("<br>");
                }
                stringArrayArray[n] = null;
            }
            stringUtility = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numOfWords += vector.size();
        return vector;
    }

    public void setText(String string) {
        int n;
        this.numOfWords = 0;
        boolean bl = false;
        if (!this.locale.equals("bn_bd") && this.locale.compareTo("unicode") == 0) {
            bl = true;
        }
        Vector<Vector> vector = new Vector<Vector>();
        while ((n = string.indexOf("<E>")) != -1) {
            String string2 = string.substring(0, n);
            if (string2 != null && string2.length() > 0) {
                if (!bl) {
                    vector.addElement(this.stringTokenized(string2, "\n", " "));
                } else {
                    vector.addElement(this.stringTokenized(string2, "\u00f5", "\u00ff"));
                }
            }
            if ((n = (string = string.substring(n + 3)).indexOf("</E>")) == -1) break;
            string2 = string.substring(0, n);
            if (string2 != null && string2.length() > 0) {
                if (!bl) {
                    vector.addElement(this.stringTokenized("<E> " + string2, "\n", " "));
                } else {
                    vector.addElement(this.stringTokenized("<E>\u00ff" + string2, "\u00f5", "\u00ff"));
                }
            }
            string = string.substring(n + 4);
        }
        if (string != null && string.length() > 0) {
            if (!bl) {
                vector.addElement(this.stringTokenized(string, "\n", " "));
            } else {
                vector.addElement(this.stringTokenized(string, "\u00f5", "\u00ff"));
            }
        }
        string = null;
        n = vector.size();
        int n2 = this.startX;
        int n3 = 0;
        this.strLen = 0;
        this.words = new String[this.numOfWords];
        this.textBits = new int[this.numOfWords][][];
        this.wordsLength = new int[this.numOfWords];
        BanglaWordConverter banglaWordConverter = new BanglaWordConverter();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                int n5;
                Vector vector2 = (Vector)vector.elementAt(i);
                int n6 = vector2.size();
                if (vector2.elementAt(0).toString().equals("<E>")) {
                    for (n5 = 1; n5 < n6; ++n5) {
                        String string3 = vector2.elementAt(n5).toString();
                        if (string3 == null || string3.length() == 0) continue;
                        this.words[n4] = string3.trim();
                        if (this.words[n4].compareTo("<br>") == 0) {
                            this.words[n4] = "\n";
                            n3 += this.fontH;
                            n2 = this.minX;
                        } else if (this.words[n4].trim().compareTo("<hr>") == 0) {
                            n3 = (int)((double)n3 + (double)this.fontH * 1.5);
                            n2 = this.minX;
                        } else {
                            this.textBits[n4] = new int[0][];
                            this.wordsLength[n4] = Default.FONT_PLAIN.stringWidth(this.words[n4]);
                            if (this.words[n4].indexOf("<b>") != -1) {
                                int n7 = n4;
                                this.wordsLength[n7] = this.wordsLength[n7] - Default.FONT_PLAIN.stringWidth("<b>");
                            }
                            if (this.words[n4].indexOf("</b>") != -1) {
                                int n8 = n4;
                                this.wordsLength[n8] = this.wordsLength[n8] - Default.FONT_PLAIN.stringWidth("</b>");
                            }
                            if (n2 + this.wordsLength[n4] > this.maxRightX) {
                                n3 += this.fontH;
                                n2 = this.minX;
                            }
                            n2 += this.wordsLength[n4] + 4;
                            this.strLen += this.wordsLength[n4] + 4;
                        }
                        ++n4;
                    }
                    if (n4 != this.numOfWords) continue;
                    break;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    this.words[n4] = vector2.elementAt(n5).toString();
                    if (this.words[n4].compareTo("<br>") == 0) {
                        this.words[n4] = "\n";
                        n3 += this.fontH;
                        n2 = this.minX;
                    } else if (this.words[n4].compareTo("<hr>") == 0) {
                        n3 = (int)((double)n3 + (double)this.fontH * 1.5);
                        n2 = this.minX;
                    } else {
                        if (!bl) {
                            this.textBits[n4] = banglaWordConverter.englishToBangla(this.words[n4]);
                            this.wordsLength[n4] = banglaWordConverter.getWidthsInPixels();
                        } else {
                            this.textBits[n4] = banglaWordConverter.getBits(this.words[n4].toCharArray());
                            this.wordsLength[n4] = banglaWordConverter.getWidthsInPixels();
                        }
                        if (this.wordsLength[n4] == 0) {
                            this.wordsLength[n4] = Default.FONT_PLAIN.stringWidth(this.words[n4]);
                        }
                        if (n2 + this.wordsLength[n4] > this.maxRightX) {
                            n3 += this.fontH;
                            n2 = this.minX;
                        }
                        n2 += this.wordsLength[n4] + 4;
                        this.strLen += this.wordsLength[n4] + 4;
                    }
                    ++n4;
                }
                if (n4 != this.numOfWords) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        vector.removeAllElements();
        vector = null;
        this.height = n3;
        this.endX = n2 - 4;
        banglaWordConverter = null;
        System.gc();
    }

    public int getFontHeight() {
        return this.fontH;
    }

    public int getWidth() {
        return this.strLen;
    }

    public int getHeight() {
        return this.height;
    }

    public int getEndX() {
        return this.endX;
    }

    public boolean getDotsExistance() {
        return this.dotsExist;
    }

    public void paint(Graphics graphics, int n) {
        CustomDrawString customDrawString = new CustomDrawString(0);
        if (this.underLine) {
            customDrawString.setUnderLine(true);
        }
        try {
            this.dotsExist = customDrawString.drawString(graphics, n, this.startX, this.topY, this.words, this.singleLine, this.fontH, this.minX, this.textBits, this.maxRightX, this.wordsLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
        customDrawString = null;
    }
}

