/*
 * Decompiled with CFR 0.152.
 */
package com.mmkrasel.utils;

import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Cache {
    private RecordStore recordStore = null;
    private String fileName = null;
    public Hashtable records;

    public Cache(String string) {
        this.fileName = string;
        this.open();
    }

    private void open() {
        try {
            this.recordStore = RecordStore.openRecordStore((String)this.fileName, (boolean)true);
            this.records = new Hashtable(1);
            this.retrieveRecords();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Close() throws RecordStoreNotOpenException, RecordStoreException {
        if (this.recordStore.getNumRecords() == 0) {
            this.recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)this.fileName);
        } else {
            this.recordStore.closeRecordStore();
        }
    }

    public void reset() throws RecordStoreNotOpenException, RecordStoreException {
        this.recordStore.closeRecordStore();
        RecordStore.deleteRecordStore((String)this.fileName);
        this.open();
    }

    private void retrieveRecords() {
        try {
            RecordEnumeration recordEnumeration = this.Enumerate();
            String string = "";
            while (recordEnumeration.hasNextElement()) {
                try {
                    string = new String(recordEnumeration.nextRecord());
                    int n = string.indexOf(":");
                    this.records.put(string.substring(n + 1), string.substring(0, n));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                recordEnumeration.hasNextElement();
            }
            recordEnumeration = null;
            string = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.gc();
    }

    public synchronized void addNewData(String string, byte[] byArray) throws Exception {
        Object object;
        int n = -1;
        try {
            object = this.records.get(string);
            if (object != null) {
                n = Integer.parseInt(object.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n == -1) {
            n = this.recordStore.getNextRecordID();
            object = (n + ":" + string).getBytes();
            this.recordStore.addRecord(object, 0, ((V)object).length);
            this.recordStore.addRecord(byArray, 0, byArray.length);
            this.records.put(string, "" + n);
            object = null;
        } else {
            this.recordStore.setRecord(n + 1, byArray, 0, byArray.length);
        }
        string = null;
        byArray = null;
        System.gc();
    }

    public void removeItem(int n) {
    }

    public void replaceItem(String string, String string2) {
    }

    public byte[] getData(String string) {
        int n = -1;
        try {
            Object v = this.records.get(string);
            if (v == null) {
                return null;
            }
            n = Integer.parseInt(v.toString());
            return this.recordStore.getRecord(n + 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private synchronized RecordEnumeration Enumerate() throws RecordStoreNotOpenException {
        return this.recordStore.enumerateRecords(null, null, false);
    }
}

