/*
 * Decompiled with CFR 0.152.
 */
package com.mmkrasel.utils;

public class BanglaWordConverter {
    private String word = "";
    private String restWord = "";
    private String syllabol = "";
    private int restWordLen = 0;
    private int syllabolLen = 0;
    private int currentIndex = 0;
    private int numberOfAlpha;
    private int[] chars;
    private int wordLength = 0;
    private int pixelsWord = 0;
    private char[][] SMALL = new char[][]{{' ', '+', '0'}, {'.', ',', '-', '?', '!', '@', ':', ';', '/', '^', '\'', '(', ')', '1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}};
    private char[][] CAPITAL = new char[][]{{' ', '+', '0'}, {'.', ',', '-', '?', '!', '@', ':', ';', '/', '^', '\'', '(', ')', '1'}, {'A', 'B', 'C', '2'}, {'D', 'E', 'F', '3'}, {'G', 'H', 'I', '4'}, {'J', 'K', 'L', '5'}, {'M', 'N', 'O', '6'}, {'P', 'Q', 'R', 'S', '7'}, {'T', 'U', 'V', '8'}, {'W', 'X', 'Y', 'Z', '9'}};
    private String[] letters = new String[]{"'", ",", ".", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", "D", "DD", "Dh", "Dr", "Dr.", "I", "N", "ND", "NG", "NT", "NTh", "Ng", "Ngg", "O", "OI", "OU", "R", "S", "ST", "STH", "ShN", "Shk", "Shp", "Sp", "Spr", "T", "TH", "TT", "Tr", "U", "^", "a", "aa", "b", "bb", "bd", "bj", "bl", "br", "ch", "chc", "chh", "chs", "d", "dd", "ddh", "dh", "dhw", "dm", "dr", "dru", "dv", "dw", "e", "ee", "f", "fl", "fr", "g", "gdh", "gg", "gh", "ghn", "ghr", "gl", "gn", "gr", "gw", "h", "hm", "i", "j", "jh", "jj", "jro", "jw", "k", "kT", "kh", "khm", "khn", "kk", "kkh", "kl", "kr", "ks", "kt", "kx", "kxm", "kxn", "l", "lD", "lT", "ll", "lp", "m", "mb", "ml", "mm", "mp", "mpr", "mv", "mw", "n", "nD", "nT", "nTh", "nch", "nd", "ndh", "ndr", "ndw", "ng", "ngo", "nj", "nm", "nn", "ns", "nt", "nth", "ntr", "ntw", "o", "oi", "oo", "p", "pT", "ph", "pl", "pn", "pr", "ps", "pt", "q", "r", "rh", "rkh", "rr", "rrg", "rri", "rrk", "ru", "s", "sT", "sTr", "sf", "sh", "shc", "shl", "shm", "shr", "shw", "sk", "skr", "sm", "sn", "sp", "sr", "st", "sth", "str", "sw", "t", "t'", "th", "tm", "tn", "tr", "tt", "tth", "tw", "u", "v", "vr", "w", "y", "z"};
    private String[] actualSearial = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "o", "a", "a", "i", "i", "I", "I", "u", "u", "U", "U", "rri", "rri", "e", "e", "OI", "OI", "O", "O", "OU", "OU", "k", "kh", "g", "gh", "Ng", "ch", "chh", "j", "jh", "NG", "T", "TH", "d", "dh", "N", "t", "th", "D", "Dh", "n", "p", "f", "b", "w", "v", "m", "z", "z", "r", "l", "sh", "S", "s", "h", "R", "rh", "y", "t'", "ng", ":", "^", "kT", "kk", "kl", "kr", "ks", "kt", "kx", "kxm", "kxn", "gw", "gdh", "gg", "ghr", "gl", "gn", "gr", "chc", "chs", "jj", "jro", "jw", "TT", "Tr", "dd", "ddh", "dhw", "dm", "dr", "dru", "dv", "dw", "ND", "NT", "NTh", "Ngg", "tm", "tr", "tt", "tth", "tw", "DD", "Dr", "Dr.", "nD", "ns", "nT", "nTh", "nch", "nd", "ndh", "ndr", "ndw", "nj", "nm", "nn", "nt", "nth", "ntr", "ntw", "pT", "pl", "pn", "pr", "ps", "pt", "fl", "fr", "bb", "bd", "bj", "br", "vr", "mb", "ml", "mm", "mp", "mpr", "mv", "mw", "ru", "rkh", "rr", "rrg", "rrk", "lD", "lT", "ll", "lp", "shc", "shl", "shm", "shr", "shw", "ST", "STH", "ShN", "Shk", "Shp", "Sp", "Spr", "sp", "sr", "st", "sth", "sw", "hm", "sT", "sf", "sk", "skr", "sm", "sn", "oi", ",", ".", "'", "sTr", "str", "ghn", "tn", "bl"};
    private int[] banglaAlphaIndex = new int[]{187, 185, 186, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 70, 48, 112, 49, 113, 114, 15, 45, 103, 40, 104, 105, 35, 106, 27, 25, 29, 65, 62, 165, 166, 167, 168, 169, 170, 171, 41, 42, 93, 94, 19, 71, 11, 11, 53, 139, 140, 141, 192, 142, 36, 88, 37, 89, 43, 95, 96, 44, 97, 98, 99, 100, 101, 102, 23, 15, 52, 137, 138, 33, 82, 83, 34, 190, 84, 85, 86, 87, 81, 64, 177, 13, 38, 39, 90, 91, 92, 31, 72, 32, 79, 80, 73, 78, 74, 75, 76, 77, 78, 79, 80, 60, 156, 157, 158, 159, 56, 144, 145, 146, 147, 148, 149, 150, 50, 115, 117, 118, 119, 120, 121, 122, 123, 69, 106, 124, 125, 126, 116, 127, 128, 129, 130, 10, 184, 17, 51, 131, 52, 132, 133, 134, 135, 136, 31, 59, 66, 152, 153, 154, 21, 155, 151, 63, 178, 188, 179, 61, 160, 161, 162, 163, 164, 180, 181, 182, 183, 172, 173, 174, 175, 189, 176, 46, 68, 47, 107, 191, 108, 109, 110, 111, 17, 55, 143, 54, 67, 57};
    private int[] vowels = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
    private int[] similiarChar = new int[]{10, 13, 14, 15, 16, 17, 18, 19, 20, 25, 26, 27, 28, 35, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 59, 62, 63, 65, 69, 69, 72, 77, 93, 94, 95, 99, 103, 104, 105, 108, 109, 112, 113, 115, 117, 118, 120, 127, 128, 131, 136, 165, 166, 170, 172, 174, 175, 178, 184, 188, 189};
    private int[][] alphabets = new int[][]{{28, 34, 65, 65, 65, 65, 65, 34, 28, 0, 0, 0, 8}, {96, 32, 16, 8, 4, 4, 52, 72, 48, 0, 0, 0, 8}, {96, 32, 16, 8, 8, 48, 64, 32, 16, 12, 0, 0, 0, 8}, {224, 272, 264, 132, 4, 1028, 520, 272, 224, 0, 0, 0, 10}, {56, 68, 68, 40, 16, 40, 68, 68, 56, 0, 0, 0, 8}, {65, 128, 360, 528, 1056, 1088, 1088, 1056, 544, 448, 0, 0, 0, 10}, {128, 128, 1152, 1168, 1128, 1032, 520, 272, 224, 0, 0, 0, 10}, {24, 36, 66, 70, 58, 2, 2, 2, 2, 1, 0, 0, 0, 8}, {128, 64, 67, 76, 112, 72, 68, 68, 72, 48, 0, 0, 0, 8}, {96, 64, 48, 12, 2, 49, 73, 17, 18, 12, 0, 0, 0, 8}, {4095, 196, 292, 212, 2068, 1044, 548, 468, 12, 4, 0, 0, 0, 11}, {65535, 3144, 4680, 4424, 35144, 16712, 8776, 7496, 200, 72, 0, 0, 0, 14}, {15, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 3}, {2048, 1792, 128, 128, 4092, 448, 544, 464, 16, 544, 448, 256, 192, 48, 0, 0, -4, 10}, {120, 132, 130, 64, 240, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0, 4, -4, 8}, {2048, 1792, 128, 128, 4092, 384, 584, 552, 304, 64, 2432, 1664, 64, 48, 0, 0, -4, 10}, {2016, 2064, 1928, 72, 28, 8, 8, 8, 8, 8, 8, 8, 8, 8, 7, 7, -4, 10}, {2048, 1792, 128, 128, 4092, 128, 144, 168, 1096, 520, 264, 144, 96, 0, 0, -4, 10}, {64, 160, 80, 12, 4, 8, 11, 8}, {2048, 1792, 128, 128, 4092, 128, 144, 168, 1096, 520, 264, 1168, 864, 0, 0, -4, 10}, {64, 128, 96, 16, 8, 4, 8, 11, 8}, {40, 44, 2920, 1192, 296, 552, 296, 184, 104, 40, 0, 0, 0, 10}, {4, 8, 4, 2, 5, 5, 11, 4}, {96, 144, 336, 336, 144, 1040, 1040, 976, 48, 16, 0, 0, 0, 10}, {255, 16, 32, 64, 64, 64, 64, 64, 32, 24, 0, 0, 0, 5}, {32, 400, 584, 424, 2096, 2080, 1056, 928, 96, 32, 0, 0, 0, 10}, {128, 96, 32, 16, 252, 16, 32, 64, 64, 64, 64, 64, 32, 24, 0, 0, -4, 6}, {480, 656, 776, 104, 144, 1128, 1032, 520, 272, 224, 0, 0, 0, 10}, new int[0], {8, 484, 532, 216, 288, 2256, 1032, 520, 272, 224, 0, 0, 0, 10}, {8, 4, 4, 2, 15, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, -4, 3}, {4095, 32, 240, 808, 1060, 1060, 552, 416, 96, 32, 0, 0, 0, 11}, {776, 1164, 584, 2632, 1160, 264, 200, 40, 24, 8, 0, 0, 0, 10}, {16, 924, 1104, 1072, 784, 144, 1168, 784, 16, 16, 16, 0, 0, -1, 10}, {4092, 1032, 2312, 1672, 72, 392, 520, 456, 56, 8, 0, 0, 0, 10}, {1280, 656, 296, 200, 1032, 520, 272, 224, 0, 0, 0, 10}, {4092, 512, 960, 560, 520, 520, 528, 544, 704, 768, 0, 0, 0, 10}, {4092, 1024, 1728, 1312, 1168, 1096, 1168, 1184, 1296, 1548, 0, 0, 0, 10}, {4094, 128, 320, 560, 648, 2372, 2084, 1064, 584, 388, 0, 0, 0, 11}, {4072, 44, 104, 424, 552, 1064, 552, 440, 104, 40, 0, 0, 0, 10}, {784, 1192, 1096, 592, 96, 2128, 1096, 872, 208, 64, 0, 0, 0, 10}, {2048, 1792, 128, 64, 4092, 512, 512, 608, 656, 592, 528, 544, 576, 384, 0, 0, -4, 10}, {2048, 1792, 128, 128, 4092, 256, 704, 544, 272, 136, 264, 520, 528, 480, 0, 0, -4, 10}, {4092, 512, 544, 592, 656, 656, 272, 16, 16, 8, 0, 0, 0, 10}, {524, 1048, 872, 136, 264, 520, 392, 104, 24, 8, 0, 0, 0, 10}, {912, 1116, 1072, 1040, 592, 400, 16, 16, 16, 16, 0, 0, 0, 10}, {4092, 0, 224, 272, 2312, 1160, 520, 272, 224, 0, 0, 0, 10}, {784, 1180, 1104, 144, 784, 1040, 784, 208, 48, 16, 0, 0, 0, 10}, {4092, 128, 144, 168, 1096, 1032, 520, 272, 224, 0, 0, 0, 10}, {4088, 512, 512, 608, 656, 592, 528, 544, 576, 384, 0, 0, 0, 10}, {4092, 16, 400, 592, 1072, 1424, 592, 400, 16, 16, 0, 0, 0, 10}, {16, 415, 592, 1072, 2896, 144, 272, 528, 16, 16, 16, 0, 0, -1, 11}, {4092, 1024, 560, 296, 548, 1060, 552, 416, 96, 32, 0, 0, 0, 10}, {4092, 16, 112, 400, 1552, 1040, 784, 208, 48, 16, 0, 0, 0, 10}, {2, 6, 10, 6, 5, 5, 11, 4}, {4092, 0, 144, 296, 2244, 1028, 520, 272, 224, 0, 0, 0, 0, 10}, {4092, 1040, 528, 400, 592, 1072, 1168, 784, 16, 16, 0, 0, 0, 10}, {4092, 1040, 528, 272, 528, 1040, 784, 208, 48, 16, 0, 0, 0, 10}, {248, 16, 32, 32, 32, 32, 32, 32, 64, 128, 0, 0, 0, 5}, {4092, 16, 112, 400, 1552, 1040, 784, 208, 1072, 1552, 0, 0, 0, 10}, {4092, 8, 8, 872, 1176, 1032, 1032, 776, 8, 8, 0, 0, 0, 10}, {1100, 680, 280, 648, 1096, 8, 8, 8, 8, 8, 0, 0, 0, 10}, {4092, 520, 264, 200, 296, 536, 392, 104, 24, 8, 0, 0, 0, 10}, {4092, 1032, 520, 360, 152, 264, 1544, 8, 8, 8, 0, 0, 0, 10}, {4092, 448, 544, 464, 16, 544, 448, 256, 192, 48, 0, 0, 0, 10}, {4092, 128, 144, 2216, 1096, 520, 272, 224, 0, 192, 0, 0, 0, 10}, {4080, 1024, 1024, 1408, 1088, 1088, 1152, 1280, 576, 192, 0, 0, 0, 10}, {4092, 1040, 528, 272, 528, 1040, 784, 208, 560, 784, 0, 0, 0, 10}, {48, 72, 64, 32, 24, 4, 2, 2, 4, 8, 0, 0, 0, 8}, {0, 12, 18, 18, 76, 32, 16, 8, 4, 2, 0, 0, 0, 8}, {48, 72, 72, 48, 0, 0, 48, 72, 72, 48, 0, 0, 0, 8}, {16, 40, 146, 68, 56, 8, 8, -6, 8}, {1024, 896, 64, 4092, 64, 480, 592, 1152, 656, 272, 544, 448, 0, 0, -3, 10}, {255, 8, 28, 42, 74, 40, 28, 42, 74, 40, 24, 8, 0, 0, 0, 8}, {4092, 32, 240, 808, 1064, 1056, 800, 224, 32, 864, 1184, 544, 0, 0, 0, 10}, {4092, 128, 336, 552, 296, 32, 1056, 928, 96, 32, 0, 0, 0, 10}, {4095, 34, 242, 810, 1066, 1058, 802, 226, 558, 306, 194, 2, 0, 0, 0, 12}, {4095, 0, 960, 1068, 1042, 722, 2212, 1104, 528, 480, 0, 0, 0, 12}, {4095, 1160, 616, 1308, 650, 74, 168, 88, 8, 8, 0, 0, 0, 12}, {4095, 1169, 593, 1337, 661, 85, 177, 81, 25, 37, 27, 1, 0, 0, 0, 12}, {4095, 1160, 616, 1308, 650, 74, 168, 88, 8, 232, 280, 136, 0, 0, 0, 12}, {912, 1116, 1072, 784, 144, 1168, 816, 80, 144, 80, 48, 16, 0, 0, 0, 10}, {912, 1116, 1072, 784, 144, 1168, 816, 80, 144, 80, 48, 16, 0, 0, 0, 10}, {4095, 128, 320, 300, 2258, 1044, 530, 300, 192, 0, 0, 0, 12}, {4092, 1040, 1040, 784, 144, 272, 528, 464, 1072, 912, 112, 16, 0, 0, 0, 10}, {912, 1116, 1072, 784, 144, 1168, 784, 16, 336, 688, 528, 272, 0, 0, 0, 10}, {912, 1116, 1072, 784, 272, 528, 1040, 400, 592, 560, 272, 16, 0, 0, 0, 10}, {412, 592, 560, 400, 80, 592, 400, 1040, 528, 464, 48, 16, 0, 0, 0, 10}, {4095, 1056, 1056, 1584, 1324, 1186, 1122, 1186, 1316, 552, 16, 0, 0, 0, 12}, {4095, 1152, 1664, 1496, 1188, 1426, 1682, 1188, 200, 144, 12, 2, 0, 0, 0, 12}, {4095, 256, 640, 608, 2332, 1186, 809, 149, 68, 56, 0, 0, 0, 0, 0, 12}, {4092, 256, 736, 528, 712, 2344, 1064, 584, 408, 1064, 576, 384, 0, 0, 0, 10}, {4095, 64, 160, 280, 324, 162, 1042, 530, 294, 202, 6, 2, 0, 0, 0, 12}, {1024, 960, 32, 4092, 512, 640, 576, 576, 672, 288, 1088, 896, 0, 0, -3, 10}, {72, 56, 4, 254, 32, 36, 36, 40, 20, 68, 60, 4, 0, 0, -3, 7}, {4095, 1024, 1024, 1152, 1344, 576, 72, 84, 36, 4, 4, 0, 0, 0, 12}, {4092, 1024, 1024, 1088, 1184, 1328, 616, 168, 104, 32, 0, 0, 0, 10}, {831, 1122, 678, 298, 562, 562, 426, 102, 34, 34, 0, 0, 0, 12}, {4092, 1032, 1032, 1096, 1192, 1320, 552, 120, 168, 72, 0, 0, 0, 10}, {4092, 256, 256, 288, 336, 144, 16, 1232, 816, 16, 0, 0, 0, 10}, {4095, 256, 256, 288, 336, 146, 26, 1236, 816, 16, 0, 0, 0, 12}, {4095, 512, 576, 672, 288, 72, 1172, 612, 260, 136, 112, 0, 0, 0, 12}, {255, 64, 64, 68, 74, 82, 38, 10, 6, 2, 0, 0, 0, 8}, {892, 1216, 1088, 80, 40, 1032, 520, 272, 224, 0, 0, 0, 0, 10}, {256, 240, 8, 892, 1216, 592, 72, 72, 80, 32, 0, 0, -3, 10}, {128, 96, 16, 828, 1184, 592, 136, 264, 272, 224, 0, 0, -3, 10}, {4092, 296, 912, 1360, 616, 136, 272, 1568, 32, 16, 0, 0, 0, 10}, {4095, 4, 452, 548, 276, 1044, 548, 452, 36, 84, 44, 4, 0, 0, 0, 12}, {4092, 96, 144, 336, 336, 144, 1040, 1040, 976, 48, 16, 0, 0, 0, 10}, {4092, 480, 656, 776, 104, 144, 1128, 1032, 520, 272, 224, 0, 0, 0, 10}, {716, 1320, 1064, 200, 264, 520, 392, 104, 24, 8, 0, 0, 0, 10}, {4092, 192, 288, 1168, 528, 288, 192, 320, 576, 320, 192, 64, 0, 0, 0, 10}, {4095, 256, 352, 144, 1040, 544, 464, 20, 138, 66, 36, 24, 0, 0, 0, 12}, {4092, 128, 128, 2224, 1096, 520, 272, 232, 520, 456, 56, 8, 0, 0, 0, 10}, {4092, 128, 128, 144, 1192, 1096, 520, 275, 227, 0, 0, 0, 0, 12}, {4092, 64, 832, 1216, 592, 40, 1032, 520, 272, 224, 0, 0, 0, 10}, {4095, 66, 834, 1218, 1090, 34, 26, 294, 194, 2, 0, 0, 0, 12}, {256, 240, 8, 4092, 64, 832, 1232, 1096, 72, 72, 80, 32, 0, 0, -3, 10}, {512, 384, 64, 4092, 96, 848, 1160, 136, 264, 528, 544, 448, 0, 0, -3, 10}, {416, 608, 172, 306, 548, 1074, 812, 160, 96, 32, 0, 0, 0, 12}, {4094, 64, 832, 1216, 1096, 84, 36, 4, 4, 4, 0, 0, 0, 11}, {4088, 64, 832, 1216, 1120, 208, 336, 592, 464, 64, 0, 0, 0, 9}, {4094, 64, 832, 1216, 1096, 84, 36, 260, 228, 28, 4, 0, 0, 0, 11}, {4094, 64, 832, 1216, 1096, 84, 36, 12, 20, 12, 4, 0, 0, 0, 11}, {1728, 2352, 712, 560, 712, 2344, 1064, 584, 400, 0, 0, 0, 0, 10}, {4095, 36, 836, 1156, 1284, 196, 292, 212, 12, 4, 0, 0, 0, 12}, {254, 4, 52, 76, 36, 4, 52, 76, 36, 4, 0, 0, 0, 7}, {4092, 64, 832, 1216, 1120, 144, 1096, 520, 272, 224, 0, 0, 0, 10}, {4039, 68, 836, 1220, 580, 196, 292, 292, 68, 36, 28, 4, 0, 0, 0, 12}, {4092, 32, 800, 1232, 552, 72, 264, 200, 56, 8, 0, 0, 0, 10}, {4092, 64, 832, 1216, 96, 1168, 544, 464, 48, 80, 48, 16, 0, 0, 0, 10}, {256, 240, 8, 892, 1216, 2880, 592, 1096, 72, 72, 80, 96, 0, 0, -3, 10}, {476, 560, 1360, 144, 272, 16, 336, 688, 528, 16, 0, 0, 0, 10}, {476, 560, 1360, 144, 272, 16, 208, 304, 144, 16, 0, 0, 0, 10}, {8, 204, 296, 536, 1448, 72, 136, 8, 520, 488, 24, 8, 0, 0, -1, 10}, {892, 1160, 2696, 328, 584, 168, 2328, 1544, 8, 8, 0, 0, 0, 10}, {476, 560, 1360, 144, 304, 72, 1096, 520, 272, 224, 0, 0, 0, 10}, {4092, 1024, 560, 296, 552, 1056, 800, 224, 32, 672, 1376, 1056, 0, 0, 0, 10}, {4092, 1024, 560, 296, 552, 1056, 800, 160, 2144, 1056, 928, 96, 0, 0, 0, 10}, {4095, 130, 390, 650, 1202, 1218, 674, 410, 134, 2, 0, 0, 0, 12}, {255, 16, 48, 80, 50, 21, 9, 1, 1, 1, 0, 0, 0, 0, 0, 8}, {4095, 192, 440, 644, 2482, 2250, 1034, 522, 274, 228, 0, 0, 0, 0, 0, 12}, {4092, 16, 112, 400, 528, 1040, 1040, 784, 208, 1584, 400, 112, 0, 0, 0, 10}, {255, 0, 36, 74, 50, 2, 66, 58, 6, 32, 0, 0, 0, 8}, {4092, 1040, 528, 400, 592, 1072, 1104, 656, 144, 80, 48, 16, 0, 0, 0, 10}, {4092, 1028, 712, 1328, 1288, 520, 168, 344, 264, 8, 0, 0, 0, 10}, {4095, 1090, 834, 1218, 578, 130, 130, 98, 154, 262, 258, 130, 0, 0, 0, 12}, {4067, 1090, 642, 1338, 582, 170, 18, 34, 2, 2, 0, 0, 0, 12}, {4067, 1090, 642, 1338, 582, 170, 18, 290, 130, 122, 6, 2, 0, 0, 0, 12}, {4092, 544, 416, 608, 288, 96, 128, 1168, 1128, 520, 272, 224, 0, 0, 0, 10}, {255, 68, 42, 82, 38, 10, 18, 10, 6, 32, 0, 0, 0, 8}, {4095, 32, 96, 420, 546, 1074, 812, 160, 608, 800, 0, 0, 0, 12}, {16, 32, 12, 776, 1160, 584, 1160, 264, 200, 40, 24, 8, 0, 0, -2, 10}, {2, 4, 8, 0, 8, -4, 8}, {16, 32, 396, 584, 1064, 536, 264, 264, 1544, 8, 8, 8, 0, 0, -2, 10}, {32, 64, 4092, 32, 112, 424, 552, 1056, 800, 160, 96, 32, 0, 0, -2, 10}, {4092, 64, 1344, 2752, 80, 40, 1032, 520, 272, 224, 0, 0, 0, 10}, {512, 480, 16, 4092, 64, 1344, 2768, 72, 72, 72, 80, 32, 0, 0, -3, 10}, {4094, 16, 848, 1200, 528, 16, 848, 1200, 528, 16, 0, 0, 0, 10}, {4067, 34, 674, 1378, 58, 70, 170, 18, 34, 2, 0, 0, 0, 12}, {3519, 608, 1312, 56, 36, 34, 34, 36, 40, 16, 0, 0, 0, 12}, {3484, 592, 1328, 2192, 16, 16, 336, 688, 528, 16, 0, 0, 0, 10}, {3487, 594, 1330, 2194, 18, 58, 86, 34, 2, 2, 0, 0, 0, 12}, {8, 1580, 344, 136, 328, 552, 8, 1032, 520, 488, 24, 8, 0, 0, -1, 10}, {3484, 592, 1328, 2192, 48, 80, 144, 80, 48, 16, 0, 0, 0, 10}, {512, 480, 16, 4088, 1312, 1216, 640, 256, 576, 544, 544, 448, 0, 0, -3, 10}, {1024, 1024, 768, 128, 4095, 1216, 672, 1424, 1160, 900, 132, 260, 516, 520, 272, 224, 0, 0, -4, 12}, {4088, 1040, 532, 410, 594, 1076, 530, 474, 52, 16, 0, 0, 0, 12}, {4092, 592, 400, 96, 176, 296, 552, 416, 96, 32, 0, 0, 0, 10}, {4076, 1352, 648, 104, 152, 280, 680, 72, 136, 8, 0, 0, 0, 10}, {3971, 1154, 666, 1446, 1222, 938, 146, 34, 2, 2, 0, 0, 0, 12}, {3971, 1154, 666, 1446, 1222, 938, 146, 34, 258, 154, 102, 2, 0, 0, 0, 12}, {3971, 698, 1350, 170, 18, 34, 2, 2, 2, 2, 0, 0, 0, 12}, {4092, 1032, 1032, 776, 200, 1192, 792, 8, 520, 488, 24, 8, 0, 0, 0, 10}, {4092, 264, 2704, 1120, 144, 136, 1032, 520, 272, 224, 0, 0, 0, 10}, {4092, 264, 2704, 1120, 144, 144, 32, 192, 256, 256, 128, 96, 0, 0, 0, 10}, {4092, 648, 1336, 200, 264, 264, 200, 40, 24, 8, 0, 0, 0, 10}, {4095, 1160, 616, 1308, 650, 74, 170, 90, 10, 8, 0, 0, 0, 12}, {1024, 896, 64, 32, 4095, 1056, 544, 416, 616, 3108, 34, 34, 36, 24, 0, 0, -4, 12}, {4095, 640, 1356, 42, 202, 264, 200, 40, 24, 8, 0, 0, 0, 12}, {4092, 320, 1696, 112, 424, 552, 288, 160, 96, 32, 0, 0, 0, 10}, {4092, 640, 1280, 192, 288, 48, 1064, 936, 96, 32, 0, 0, 0, 10}, {4095, 1090, 706, 322, 1602, 130, 130, 98, 146, 266, 262, 130, 0, 0, 0, 12}, {4092, 264, 2704, 1128, 8, 200, 296, 280, 136, 8, 0, 0, 0, 10}, {2048, 1792, 128, 128, 4092, 448, 544, 464, 16, 544, 448, 256, 192, 48, 0, 0, -4, 10}, {2, 2, 4, 8, 0, 0, 8, 4}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 4}, {8, 4, 2, 0, 0, 11, 3}, {1024, 896, 64, 64, 4095, 1088, 576, 456, 1604, 68, 68, 72, 1104, 800, 224, 32, 0, 0, -4, 12}, {4092, 144, 864, 32, 80, 144, 16, 528, 464, 48, 16, 0, 0, 0, 10}, {4092, 1040, 1040, 784, 144, 784, 1040, 1008, 16, 208, 304, 272, 0, 0, 0, 10}, {4092, 96, 144, 136, 1032, 520, 272, 224, 32, 416, 608, 544, 0, 0, 0, 10}, {4092, 32, 224, 800, 1056, 1056, 800, 224, 32, 864, 1184, 544, 0, 0, 0, 10}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {4, 4, 4, 4, 0, 0, -1, 4}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {8, 8, 4, 4, 0, 0, -1, 4}, {4, 4, 8, 8, 0, 0, -1, 4}, {2, 2, 2, 2, 2, 2, 0, 0, 2, 2, 0, 0, 0, 4}, {5, 5, 5, 5, 0, 0, -1, 4}, {0, 0, 0, 15, 0, 0, 0, 4}, {4, 8, 16, 32, 32, 32, 32, 32, 16, 8, 4, 0, 0, 0, 8}, {32, 16, 8, 4, 4, 4, 4, 4, 8, 16, 32, 0, 0, 0, 8}, {120, 132, 132, 68, 8, 16, 32, 32, 32, 0, 32, 0, 0, 0, 8}, {245, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 255, 0, 0, 0, 6}, {0, 0, 0, 0, 5}};

    /*
     * Opcode count of 17169 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public BanglaWordConverter() {
        this.numberOfAlpha = this.letters.length;
    }

    private boolean isVowel(int n) {
        int n2 = this.vowels.length;
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = (n3 + n4) / 2;
        while (n3 <= n4 && n != this.vowels[n5]) {
            if (n < this.vowels[n5]) {
                n4 = n5 - 1;
            } else {
                n3 = n5 + 1;
            }
            n5 = (n3 + n4) / 2;
        }
        return n == this.vowels[n5];
    }

    private boolean checkSimiliarity(int n) {
        int n2 = this.similiarChar.length;
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = (n3 + n4) / 2;
        while (n3 <= n4 && n != this.similiarChar[n5]) {
            if (n < this.similiarChar[n5]) {
                n4 = n5 - 1;
            } else if (n > this.similiarChar[n5]) {
                n3 = n5 + 1;
            }
            n5 = (n3 + n4) / 2;
        }
        return n == this.similiarChar[n5];
    }

    private void charPosition(int n) {
        if (this.wordLength == 0 && n == 67) {
            this.chars[this.wordLength++] = 13;
            this.chars[this.wordLength++] = n;
            return;
        }
        if (this.wordLength > 1 && this.isVowel(n) && !this.isVowel(this.chars[this.wordLength - 1]) && (this.chars[this.wordLength - 2] == 24 || this.chars[this.wordLength - 2] == 14) && n != 10) {
            this.chars[this.wordLength] = n;
            ++this.wordLength;
            return;
        }
        if (this.wordLength > 0) {
            if (n == 10) {
                return;
            }
            if (!this.isVowel(this.chars[this.wordLength - 1]) && this.chars[this.wordLength - 1] != 153 && n == 57) {
                if (this.word.charAt(this.currentIndex - 1) == 'o') {
                    this.chars[this.wordLength] = 57;
                    ++this.wordLength;
                    return;
                }
                this.chars[this.wordLength] = 58;
                ++this.wordLength;
                return;
            }
            if (this.isVowel(n) && this.isVowel(this.chars[this.wordLength - 1])) {
                this.chars[this.wordLength] = n;
                ++this.wordLength;
                return;
            }
            if (!(this.isVowel(this.chars[this.wordLength - 1]) || n != 25 && n != 23 && n != 13)) {
                this.chars[this.wordLength] = this.chars[this.wordLength - 1];
                this.chars[this.wordLength - 1] = n + 1;
                ++this.wordLength;
                return;
            }
            if (!(this.isVowel(this.chars[this.wordLength - 1]) || n != 11 && n != 15 && n != 17 && n != 19 && n != 21)) {
                this.chars[this.wordLength] = n + 1;
                ++this.wordLength;
                return;
            }
            if (!this.isVowel(this.chars[this.wordLength - 1]) && n == 27) {
                this.chars[this.wordLength] = this.chars[this.wordLength - 1];
                this.chars[this.wordLength - 1] = 24;
                this.chars[this.wordLength + 1] = 12;
                this.wordLength += 2;
                return;
            }
            if (!this.isVowel(this.chars[this.wordLength - 1]) && n == 29) {
                this.chars[this.wordLength] = this.chars[this.wordLength - 1];
                this.chars[this.wordLength - 1] = 24;
                this.chars[this.wordLength + 1] = 30;
                this.wordLength += 2;
                return;
            }
        }
        this.chars[this.wordLength] = n;
        ++this.wordLength;
    }

    private int searchForIndex(String string) {
        int n = 0;
        int n2 = this.numberOfAlpha - 1;
        int n3 = (n + n2) / 2;
        while (n <= n2 && !string.equals(this.letters[n3])) {
            if (string.compareTo(this.letters[n3]) < 0) {
                n2 = n3 - 1;
            } else {
                n = n3 + 1;
            }
            n3 = (n + n2) / 2;
        }
        if (string.equals(this.letters[n3])) {
            return n3;
        }
        return -1;
    }

    private boolean findChar() {
        int n = this.searchForIndex(this.syllabol);
        if (n == -1) {
            return false;
        }
        String string = this.syllabol;
        String string2 = this.letters[n];
        if (!this.checkSimiliarity(this.banglaAlphaIndex[n])) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.equals(string2)) {
            try {
                this.restWord = this.restWord.substring(this.syllabolLen);
                this.restWordLen = this.restWord.length();
                this.charPosition(this.banglaAlphaIndex[n]);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.restWordLen = 0;
                return false;
            }
        }
        return false;
    }

    private boolean checkForChars() {
        try {
            char c = this.syllabol.charAt(0);
            if (c >= '0' && c <= '9') {
                this.chars[this.wordLength++] = c - 48;
                this.restWord = this.restWord.substring(1);
                this.restWordLen = this.restWord.length();
                ++this.currentIndex;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.word.substring(this.currentIndex + 1, this.currentIndex + 4).equals("rri")) {
                this.syllabolLen = 1;
                this.syllabol = "" + this.syllabol.charAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.syllabolLen == 3) {
                if (this.findChar()) {
                    this.currentIndex += 3;
                    return true;
                }
                if (this.syllabol.toLowerCase().equals("eid")) {
                    this.chars[this.wordLength++] = 15;
                    this.chars[this.wordLength++] = 43;
                    return false;
                }
                this.syllabolLen = 2;
                this.syllabol = this.syllabol.substring(0, this.syllabolLen);
            }
            if (this.syllabolLen == 2) {
                if (this.findChar()) {
                    this.currentIndex += 2;
                    return true;
                }
                if (this.syllabol.equals("ea")) {
                    this.chars[this.wordLength++] = 23;
                    this.chars[this.wordLength++] = 58;
                    this.chars[this.wordLength++] = 12;
                    this.currentIndex += 2;
                    this.restWord = this.restWord.substring(this.syllabolLen);
                    this.restWordLen = this.restWord.length();
                    return true;
                }
                this.syllabolLen = 1;
                this.syllabol = "" + this.syllabol.charAt(0);
            }
            if (this.syllabolLen == 1 && this.findChar()) {
                ++this.currentIndex;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public int[][] englishToBangla(String string) {
        this.chars = new int[160];
        this.syllabol = "";
        this.syllabolLen = 0;
        this.wordLength = 0;
        this.pixelsWord = 0;
        this.word = string;
        this.currentIndex = 0;
        this.restWord = string;
        this.restWordLen = string.length();
        while (this.restWordLen != 0) {
            if (this.restWordLen > 3) {
                this.syllabolLen = 3;
                this.syllabol = this.restWord.substring(0, this.syllabolLen);
            } else {
                this.syllabolLen = this.restWordLen;
                this.syllabol = this.restWord;
            }
            if (this.checkForChars()) continue;
            break;
        }
        return this.getBits();
    }

    private int[] getChars() {
        int[] nArray = new int[this.wordLength];
        for (int i = 0; i < this.wordLength; ++i) {
            nArray[i] = this.chars[i];
        }
        return nArray;
    }

    public int getWidthsInPixels() {
        return this.pixelsWord;
    }

    public int getLength() {
        return this.wordLength;
    }

    private int[][] getBits() {
        int[] nArray = this.getChars();
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        int n2 = 0;
        this.pixelsWord = 0;
        for (int i = 0; i < n; ++i) {
            n2 = nArray[i];
            nArrayArray[i] = this.alphabets[n2];
            int n3 = nArrayArray[i].length - 4;
            this.pixelsWord += nArrayArray[i][n3 + 3] - nArrayArray[i][n3 + 1];
        }
        return nArrayArray;
    }

    public int[][] getBits(char[] cArray) {
        int n = cArray.length;
        int[][] nArrayArray = new int[n][];
        char c = '\u0000';
        this.pixelsWord = 0;
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            nArrayArray[i] = this.alphabets[c];
            int n2 = nArrayArray[i].length - 4;
            this.pixelsWord += nArrayArray[i][n2 + 3] - nArrayArray[i][n2 + 1];
        }
        return nArrayArray;
    }

    public int getNumberOfLetters() {
        return this.numberOfAlpha;
    }

    public int[] getLetter(int n) {
        return this.alphabets[n];
    }

    public char[] getSmallLetter(int n) {
        return this.SMALL[n];
    }

    public char[] getCapitalLetter(int n) {
        return this.CAPITAL[n];
    }

    public String getLetterString(int n) {
        return this.actualSearial[n];
    }
}

