/*
 * Decompiled with CFR 0.152.
 */
package com.mmkrasel.banglacalendar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Records {
    RecordStore recordStore = null;
    String fileName = null;
    private String[][] allRecords;
    private int numRecords;

    public Records(String string) {
        this.fileName = string;
        try {
            this.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            this.setRecords();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Close() throws RecordStoreNotOpenException, RecordStoreException {
        if (this.recordStore.getNumRecords() == 0) {
            String string = this.recordStore.getName();
            this.recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)string);
        } else {
            this.recordStore.closeRecordStore();
        }
    }

    public void DeleteRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        this.recordStore.closeRecordStore();
        RecordStore.deleteRecordStore((String)this.fileName);
    }

    public synchronized void AddNew(String string, String string2) throws RecordStoreException {
        int n = this.isDateExist(string, string2);
        if (n != -1) {
            this.RemoveItem(n);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string + "-" + string2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.recordStore.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.allRecords = null;
        this.setRecords();
    }

    private int isDateExist(String string, String string2) {
        for (int i = 0; i < this.numRecords; ++i) {
            if (!string.equals(this.allRecords[i][0])) continue;
            return i;
        }
        return -1;
    }

    public void RemoveItem(int n) {
        try {
            int n2;
            for (n2 = n; n2 < this.numRecords - 1; ++n2) {
                this.allRecords[n2][0] = this.allRecords[n2 + 1][0];
                this.allRecords[n2][1] = this.allRecords[n2 + 1][1];
            }
            --this.numRecords;
            this.DeleteRecordStore();
            this.recordStore = RecordStore.openRecordStore((String)this.fileName, (boolean)true);
            for (n2 = 0; n2 < this.numRecords; ++n2) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeUTF(this.allRecords[n2][0] + "-" + this.allRecords[n2][1]);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    this.recordStore.addRecord(byArray, 0, byArray.length);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            recordStoreNotOpenException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public String GetNote(String string) {
        for (int i = 0; i < this.numRecords; ++i) {
            if (!string.equals(this.allRecords[i][0])) continue;
            return this.allRecords[i][1];
        }
        return "";
    }

    public void checkValidity(String string) throws RecordStoreException {
        for (int i = 0; i < this.numRecords; ++i) {
            if (this.allRecords[i][0].compareTo(string) >= 0) continue;
            this.RemoveItem(i);
            --i;
        }
    }

    private void setRecords() {
        try {
            this.numRecords = this.recordStore.getNumRecords();
            this.allRecords = new String[this.numRecords][2];
            RecordEnumeration recordEnumeration = this.Enumerate();
            String string = "";
            int n = 0;
            while (recordEnumeration.hasNextElement()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                string = dataInputStream.readUTF();
                int n2 = string.indexOf("-");
                this.allRecords[n][0] = string.substring(0, n2);
                this.allRecords[n][1] = string.substring(n2 + 1);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized RecordEnumeration Enumerate() throws RecordStoreNotOpenException {
        return this.recordStore.enumerateRecords(null, null, false);
    }
}

